/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.function.special;

import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.util.functions.Action3;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.values.NullValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ValAction2Arg<T extends Value>
extends Function {
    private boolean failOnInvalidArgs = true;
    private Action3<T, Value, SourceRange> action;

    public ValAction2Arg(String string, Action3<T, Value, SourceRange> action3) {
        super(string, 2, null, true);
        this.action = action3;
    }

    public ValAction2Arg(String string, boolean bl, Action3<T, Value, SourceRange> action3) {
        super(string, 2, null, true);
        this.action = action3;
        this.failOnInvalidArgs = bl;
    }

    @Override
    public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        if (valueArray[0].isInvalid()) {
            return NullValue.instance;
        }
        if (this.failOnInvalidArgs && valueArray[1].isInvalid()) {
            throw new AsmErrorException("Function can't be called with invalid argument (Unresolved label, etc.)", sourceRange);
        }
        this.action.apply(valueArray[0], valueArray[1], sourceRange);
        return NullValue.instance;
    }
}

